	org 62200

	ld hl,dwdata
	ld de,16384
	call dzx0_standard
	ret

; -----------------------------------------------------------------------------
; ZX0 decoder by Einar Saukas & Urusergi
; "Standard" version (68 bytes only)
; -----------------------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
; -----------------------------------------------------------------------------

dzx0_standard:
        ld      bc, $ffff               ; preserve default offset 1
        push    bc
        inc     bc
        ld      a, $80
dzx0s_literals:
        call    dzx0s_elias             ; obtain length
        ldir                            ; copy literals
        add     a, a                    ; copy from last offset or new offset?
        jr      c, dzx0s_new_offset
        call    dzx0s_elias             ; obtain length
dzx0s_copy:
        ex      (sp), hl                ; preserve source, restore offset
        push    hl                      ; preserve offset
        add     hl, de                  ; calculate destination - offset
        ldir                            ; copy from offset
        pop     hl                      ; restore offset
        ex      (sp), hl                ; preserve offset, restore source
        add     a, a                    ; copy from literals or new offset?
        jr      nc, dzx0s_literals
dzx0s_new_offset:
        pop     bc                      ; discard last offset
        ld      c, $fe                  ; prepare negative offset
        call    dzx0s_elias_loop        ; obtain offset MSB
        inc     c
        ret     z                       ; check end marker
        ld      b, c
        ld      c, (hl)                 ; obtain offset LSB
        inc     hl
        rr      b                       ; last offset bit becomes first length bit
        rr      c
        push    bc                      ; preserve new offset
        ld      bc, 1                   ; obtain length
        call    nc, dzx0s_elias_backtrack
        inc     bc
        jr      dzx0s_copy
dzx0s_elias:
        inc     c                       ; interlaced Elias gamma coding
dzx0s_elias_loop:
        add     a, a
        jr      nz, dzx0s_elias_skip
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
dzx0s_elias_skip:
        ret     c
dzx0s_elias_backtrack:
        add     a, a
        rl      c
        rl      b
        jr      dzx0s_elias_loop
; -----------------------------------------------------------------------------

dwdata:	; 2,655 bytes
defb 149,0,98,56,0,81,174,28,130,5,143,14,7,52,82,136,231,238,63,255
defb 254,192,86,239,15,194,254,188,254,124,10,240,130,32,8,1,127,161,128,94
defb 197,235,130,115,33,129,192,221,0,86,149,30,40,120,65,162,255,100,223,239
defb 128,26,127,85,168,112,36,8,32,0,63,73,162,34,0,16,8,167,4,253
defb 17,254,13,128,0,41,15,82,134,240,130,7,100,1,255,128,26,119,166,1
defb 97,255,251,192,90,7,90,255,65,146,224,2,129,0,73,127,164,192,10,16
defb 146,1,34,4,19,254,0,0,165,3,74,192,0,47,7,128,137,248,7,2
defb 216,224,0,106,31,145,240,105,7,153,253,126,224,6,134,255,145,253,32,145
defb 16,4,1,0,106,0,72,136,13,242,163,250,96,2,149,7,40,224,0,165
defb 3,74,192,24,154,3,135,127,164,254,26,63,191,31,164,48,188,42,3,29
defb 252,128,193,0,151,113,0,36,144,96,0,64,36,9,63,121,121,163,10,36
defb 127,11,234,128,192,199,128,87,117,0,105,0,82,132,0,207,228,116,0,102
defb 247,253,248,65,134,250,36,84,170,107,69,146,97,34,8,128,32,255,68,128
defb 128,29,80,147,255,245,67,238,96,41,30,82,128,120,12,51,244,209,180,142
defb 1,199,248,215,66,7,90,1,31,90,252,21,169,1,169,248,0,16,132,22
defb 253,32,251,193,28,0,13,154,1,31,251,95,96,217,41,214,26,28,84,160
defb 56,65,166,15,145,254,41,63,82,161,1,169,1,2,66,16,127,128,6,25
defb 16,128,4,9,95,22,185,253,69,240,129,200,64,192,34,255,126,130,246,21
defb 149,32,64,128,144,4,176,8,138,36,37,72,128,100,204,87,190,8,65,82
defb 80,108,25,100,191,255,254,170,170,131,252,24,8,10,38,37,213,93,17,29
defb 118,70,52,2,82,132,115,149,7,251,253,164,72,117,20,138,149,69,206,74
defb 196,222,134,119,6,42,173,82,207,36,133,213,218,213,95,181,124,130,13,207
defb 255,252,9,153,124,249,32,160,127,107,186,221,191,107,213,80,0,102,11,253
defb 151,130,122,64,206,160,64,128,144,8,84,1,5,82,144,1,0,37,145,2
defb 145,252,162,42,169,16,37,144,94,253,39,74,146,167,171,96,33,6,169,85
defb 110,214,160,93,83,24,136,117,40,89,5,255,238,168,4,84,164,127,125,90
defb 190,90,159,40,252,134,7,85,85,72,63,36,133,171,107,109,210,213,158,138
defb 51,91,130,240,10,223,254,74,255,6,235,213,222,239,180,154,191,251,88,0
defb 128,144,7,255,95,238,129,9,143,32,37,145,2,160,0,80,137,74,129,36
defb 144,41,209,9,69,68,160,50,127,164,121,144,170,169,74,163,109,128,96,32
defb 174,175,247,252,136,187,90,248,89,139,1,200,146,4,97,149,210,69,8,234
defb 75,253,117,36,167,192,112,107,251,191,231,149,243,146,170,164,9,191,97,251
defb 191,213,171,111,122,239,99,110,111,67,213,242,120,181,192,144,229,58,215,189
defb 186,223,127,215,173,168,0,89,100,14,127,13,245,104,34,130,24,106,9,4
defb 18,130,36,38,68,134,130,228,16,41,41,69,128,144,45,127,215,213,42,73
defb 234,192,33,32,1,183,255,189,177,32,58,164,127,128,73,137,7,252,165,9
defb 2,191,170,208,64,128,191,250,234,213,84,176,24,138,15,234,192,114,207,229
defb 81,239,228,223,170,190,219,189,173,67,118,190,249,215,64,42,95,214,227,1
defb 6,175,235,239,247,245,251,255,254,180,0,150,2,191,15,127,160,136,9,65
defb 150,4,72,1,40,146,69,8,65,146,1,81,117,139,68,164,69,139,59,255
defb 73,255,240,64,239,96,190,42,237,88,223,234,129,53,83,41,120,18,117,31
defb 254,82,134,125,5,85,253,85,16,96,241,86,170,171,124,196,215,77,68,230
defb 50,1,202,169,222,79,117,77,171,109,214,219,249,192,134,0,33,253,127,138
defb 7,191,137,247,40,251,94,189,189,95,127,128,235,84,32,36,1,219,5,214
defb 130,37,8,64,9,100,5,0,32,130,75,82,72,73,36,37,81,85,42,149
defb 80,72,14,20,253,83,218,170,144,105,48,68,71,40,16,41,127,254,255,212
defb 197,58,169,174,33,246,38,127,218,68,33,136,1,87,86,164,17,100,251,42
defb 213,168,79,109,126,160,63,224,154,234,68,175,74,251,126,172,223,183,79,216
defb 172,0,96,130,1,207,255,254,138,30,255,36,163,109,245,183,219,238,247,189
defb 236,22,64,2,89,254,9,116,0,0,128,192,18,25,209,104,40,148,40,18
defb 29,146,12,253,37,73,178,114,188,86,10,29,82,137,101,97,0,46,216,24
defb 136,18,72,165,63,255,128,169,34,118,165,18,178,240,113,162,65,81,106,10
defb 93,245,83,193,134,119,221,86,173,235,192,22,25,1,249,191,255,128,155,97
defb 117,41,22,3,2,183,251,122,253,253,171,215,96,6,36,3,43,177,50,109
defb 6,106,1,247,10,250,238,189,191,32,239,118,9,100,0,174,2,53,73,84
defb 18,72,113,18,254,146,150,73,113,64,37,144,171,255,222,148,42,168,120,97
defb 162,13,72,75,186,170,43,76,17,136,36,164,218,134,93,82,2,106,85,173
defb 237,127,214,0,42,3,227,102,33,137,2,166,170,164,7,33,247,118,186,177
defb 117,112,99,7,178,89,62,156,112,122,146,129,123,151,234,218,221,239,171,86
defb 223,122,176,170,82,127,222,248,0,130,74,77,253,93,235,223,189,239,43,118
defb 218,32,192,138,63,191,130,224,42,235,255,245,33,136,235,95,106,215,126,128
defb 183,123,179,79,73,65,230,190,3,85,126,24,62,238,221,109,223,238,49,255
defb 208,76,116,42,5,104,109,108,175,96,238,253,219,175,125,167,1,29,138,225
defb 133,152,15,254,10,254,251,111,255,123,215,251,85,192,154,213,62,191,146,240
defb 63,223,119,222,90,203,111,35,245,239,254,213,245,191,127,9,249,71,203,218
defb 122,23,221,217,65,228,253,191,123,199,186,111,127,109,171,250,191,106,124,253
defb 89,92,207,66,168,99,251,123,145,155,249,191,223,109,246,251,253,254,237,250
defb 251,190,174,181,117,129,33,191,215,214,132,17,187,174,190,197,29,253,118,239
defb 95,175,162,149,215,77,94,189,127,235,94,219,226,250,148,163,134,240,224,59
defb 251,248,205,153,195,61,178,174,91,76,147,250,190,237,191,235,183,163,62,221
defb 128,55,194,79,134,83,6,178,87,254,135,127,246,183,119,218,1,168,236,235
defb 164,184,100,217,6,107,171,162,82,191,175,206,110,250,215,50,253,9,237,87
defb 102,252,153,224,223,1,127,223,84,106,71,126,200,235,192,154,234,63,207,147
defb 248,120,217,202,182,219,117,110,222,254,253,236,206,224,29,250,163,141,189,183
defb 220,0,111,167,182,131,214,197,137,160,250,202,246,254,189,247,129,215,146,254
defb 85,85,160,126,240,72,28,239,218,254,245,245,222,191,175,119,134,181,191,109
defb 86,251,223,183,123,112,134,254,8,137,149,128,145,195,158,4,15,235,183,247
defb 117,110,251,93,106,251,109,211,147,245,237,238,214,190,247,246,224,28,218,130
defb 87,187,144,1,241,117,38,194,32,7,175,147,237,171,118,246,189,223,173,26
defb 235,221,0,200,176,248,29,170,210,51,127,187,186,218,197,139,254,232,80,194
defb 2,13,143,222,180,21,210,217,127,126,251,111,109,198,210,129,193,33,119,128
defb 35,95,237,95,2,136,64,222,125,247,0,168,237,243,15,82,210,255,164,246
defb 155,191,191,127,171,87,111,253,41,192,36,252,160,31,79,127,128,155,251,239
defb 125,86,89,54,221,247,13,77,221,189,91,91,235,189,162,1,125,24,169,188
defb 77,15,176,109,237,106,63,219,121,95,123,237,147,40,251,181,235,187,93,189
defb 214,187,175,252,134,247,186,17,76,218,198,223,26,14,14,190,253,221,59,187
defb 174,133,173,46,49,183,73,93,182,187,191,235,90,191,251,134,1,254,17,135
defb 126,248,12,118,171,236,109,28,248,206,107,55,119,191,187,214,51,180,253,182
defb 54,238,146,252,12,101,91,87,117,105,0,183,221,111,175,0,170,223,252,70
defb 12,207,117,2,171,117,85,191,251,221,65,194,173,164,247,149,126,174,75,37
defb 214,43,237,237,1,239,95,120,0,32,229,159,253,127,117,165,60,155,251,127
defb 237,246,253,251,253,127,210,57,126,134,189,64,53,234,223,72,219,222,223,15
defb 182,31,91,145,141,119,246,247,111,201,125,243,146,127,127,254,93,174,238,243
defb 78,227,173,239,125,88,211,188,191,87,213,110,135,182,253,58,238,251,191,251
defb 156,254,164,133,121,123,105,228,14,30,235,209,225,213,237,123,93,107,247,179
defb 57,253,91,86,223,125,109,190,239,213,191,53,182,252,75,78,1,8,121,224
defb 240,3,160,224,137,53,87,147,254,173,173,85,238,187,30,124,208,171,218,238
defb 224,73,214,213,173,254,1,25,254,254,183,245,122,104,244,74,31,35,222,192
defb 90,7,246,131,170,175,110,237,98,96,176,144,216,31,0,44,75,250,213,216
defb 247,232,80,219,251,173,106,32,127,151,245,31,124,15,227,226,254,239,46,255
defb 191,143,125,118,223,107,187,91,162,94,0,100,94,123,213,234,38,222,214,133
defb 212,107,162,246,219,125,158,215,182,190,108,194,191,106,85,245,119,120,27,234
defb 88,23,217,235,238,3,173,235,255,125,213,44,179,223,35,61,187,94,229,127
defb 125,106,239,211,83,107,128,224,247,31,30,190,245,246,251,93,253,190,173,191
defb 105,0,172,181,214,223,181,217,39,247,218,248,83,45,0,156,241,67,88,47
defb 106,79,108,194,116,5,190,187,215,33,163,212,251,93,236,254,198,49,44,1
defb 154,117,197,61,210,252,237,68,23,106,27,63,146,35,218,43,111,125,191,222
defb 139,85,251,98,40,191,146,29,126,99,10,183,63,94,255,203,144,247,98,0
defb 8,95,240,7,172,75,187,112,23,187,189,223,251,117,91,45,219,137,188,212
defb 252,64,183,201,37,126,146,219,246,235,251,218,254,62,65,5,117,223,213,125
defb 163,1,175,135,251,86,189,92,142,252,154,128,191,169,125,91,187,117,125,85
defb 247,247,254,183,183,90,213,251,111,235,247,229,171,25,113,35,117,192,224,123
defb 31,28,235,95,191,173,246,214,170,215,121,139,215,210,90,183,110,57,243,126
defb 117,39,108,45,15,90,239,248,130,241,192,112,7,88,222,170,183,180,24,219
defb 187,215,123,109,227,169,84,96,7,252,24,204,110,183,83,78,8,199,214,247
defb 106,118,199,46,250,202,13,226,30,209,87,201,89,55,123,189,246,77,251,191
defb 0,152,200,119,183,11,1,247,204,0,152,127,237,237,40,189,96,129,15,225
defb 79,254,189,251,215,109,1,175,201,31,139,253,90,221,254,79,7,138,131,34
defb 93,184,171,192,211,19,77,197,45,101,219,24,133,11,247,219,182,245,127,94
defb 219,93,54,11,195,24,171,237,248,199,46,113,138,209,239,239,93,246,223,175
defb 239,223,223,219,135,71,191,126,175,245,94,184,58,185,22,188,83,119,192,224
defb 59,191,188,182,250,237,247,91,253,127,122,173,239,190,169,191,123,191,94,175
defb 213,181,191,219,192,13,249,217,15,185,204,192,96,27,48,157,213,91,191,90
defb 2,111,118,221,183,205,83,58,177,176,113,64,141,181,218,249,76,129,214,123
defb 171,95,0,170,131,127,3,49,129,167,0,244,39,254,72,22,143,125,181,196
defb 219,131,213,79,219,69,21,202,18,254,255,97,216,124,151,135,141,240,160,0
defb 132,249,70,229,119,157,223,110,247,116,7,168,9,247,59,181,247,126,183,226
defb 130,161,252,129,86,1,201,126,214,41,163,183,237,122,182,137,175,211,112,251
defb 95,213,181,242,234,97,44,189,157,72,99,107,73,128,229,219,201,117,87,221
defb 186,245,118,254,211,112,94,170,213,219,221,190,235,56,114,118,251,97,9,55
defb 224,1,163,187,219,111,70,3,45,237,74,28,25,108,91,250,116,71,209,201
defb 181,250,63,55,61,254,154,248,255,128,32,32,57,2,148,56,120,130,71,212
defb 116,248,255,192,7,129,254,65,105,57,245,192,117,85,88
